<?php

namespace App\Models\Office;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Office extends Model 
{

    protected $table = 'offices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('office_name', 'office_description', 'office_email', 'office_website', 'Longitude', 'office_opening_date', 'office_logo', 'office_license', 'office_phone_1', 'office_phone_2', 'office_phone_3', 'latitude');

    public function case()
    {
        return $this->hasMany('Xcase');
    }

}